 IF EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_RC_DEB_RC_CLI_CONV_BLOQUEIO]'))
	DROP VIEW [dbo].[V_RC_DEB_RC_CLI_CONV_BLOQUEIO]
GO
CREATE VIEW [dbo].[V_RC_DEB_RC_CLI_CONV_BLOQUEIO]
AS
	SELECT 
		RC_CLI_CONV.CD_CONV,
		dbo.RC_DEB.CD_CLI, 
		( CASE WHEN ISNULL(RC_MDL_VENDA.DIAS_CAREN_ATRASO, 0) > 0 THEN 
				DATEADD(DAY, RC_MDL_VENDA.DIAS_CAREN_ATRASO, 	CASE WHEN RC_DEB.DT_PRORROG IS NULL THEN RC_DEB.DT_VENCTO ELSE RC_DEB.DT_PRORROG END)
		ELSE DATEADD(DAY, dbo.RC_MDL_VENDA.DIAS_BLOQ_ATRASO, 
		CASE WHEN RC_DEB.DT_PRORROG IS NULL THEN RC_DEB.DT_VENCTO ELSE RC_DEB.DT_PRORROG END)
			 END )   AS DT_LIMITE
		,CONVERT(dATE,GETDATE()) AS DT_ATUAL
	FROM
		dbo.RC_DEB
		INNER JOIN dbo.RC_CLI_CONV ON
			dbo.RC_DEB.CD_EMP = dbo.RC_CLI_CONV.CD_EMP AND
			dbo.RC_DEB.CD_CLI = dbo.RC_CLI_CONV.CD_CLI
		INNER JOIN dbo.RC_MDL_VENDA ON
			dbo.RC_MDL_VENDA.CD_EMP = dbo.RC_CLI_CONV.CD_EMP AND
			dbo.RC_MDL_VENDA.CD_MDL_VD = dbo.RC_CLI_CONV.CD_MDL_VD
	WHERE
		( dbo.RC_DEB.CD_EMP = 1 ) AND
		( dbo.RC_DEB.STS_DP IN ( 0, 2 ) ) AND
		( dbo.RC_DEB.SLD_DP > 0 ) AND
		(RC_MDL_VENDA.FLAG_BLOQ_CLI_PAG_PARC=1) AND
		(RC_CLI_CONV.CONV_HABILITADO=0)

GO

GO 

